function initSelect2(element, placeholder = "Procurar por") {
    $(element).select2({
        theme: 'bootstrap4',
        width: $(element).data('width') || ($(element).hasClass('w-100') ? '100%' : 'style'),
        placeholder: $(element).data('placeholder') || placeholder,
        allowClear: $(element).data('allow-clear') === true,
        minimumResultsForSearch: 0 // Força a exibição da barra de pesquisa
    }).trigger('change');
}

function parseToMZN(number) {
    let cleanNumber = parseFloat(twoDecimalPlaces(number)) || 0;
    return $.number(cleanNumber, 2, '.', ' ') + " MZN";
}

function parseFromMZNToNumber(formattedValue) {
    if (!formattedValue) return 0;
    let cleanNumber = formattedValue.replace(/\sMZN$/, "").replace(/ /g, "");

    return parseFloat(cleanNumber) || 0;
}
function twoDecimalPlaces(number) {
    return (isNaN(number) || number === "" || number === null || number === undefined)
        ? 0
        : number.toString().match(/^-?\d+(?:\.\d{0,2})?/)[0];
}

